/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import imgui.ImGui;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ProjectedText {
    private static float lastFog = 0.0f;
    private static float scale = 0.0f;
    private static float width = 0.0f;
    private static float height = 0.0f;

    public static void setupProjectedText() {
        scale = 2.0f * Math.max(1.0f, Math.min(ImGui.getIO().getDisplayFramebufferScaleX(), ImGui.getIO().getDisplayFramebufferScaleY()));
        width = (float)class_310.method_1551().method_22683().method_4489() / scale;
        height = (float)class_310.method_1551().method_22683().method_4506() / scale;
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, width, height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_34426();
        poseStack.method_46416(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        lastFog = RenderSystem.getShaderFogStart();
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
    }

    public static void renderProjectedText(String text, class_4587 matrix, Matrix4f projection, float x, float y, float z) {
        class_327 font = class_310.method_1551().field_1772;
        Vector4f transformed = matrix.method_23760().method_23761().transform(new Vector4f(x, y, z, 1.0f));
        transformed = projection.transform(transformed);
        int stringWidth = class_310.method_1551().field_1772.method_1727(text);
        if (transformed.w < 0.0f) {
            return;
        }
        float screenX = (float)Math.round(((transformed.x / transformed.w * 0.5f + 0.5f) * width - (float)stringWidth / 2.0f) * scale) / scale;
        float f = (-transformed.y / transformed.w * 0.5f + 0.5f) * height;
        Objects.requireNonNull(font);
        float screenY = (float)Math.round((f - 9.0f / 2.0f) * scale) / scale;
        font.method_37296(class_2561.method_43470((String)text).method_30937(), screenX, screenY, -3351041, -13420737, new Matrix4f(), (class_4597)class_310.method_1551().method_22940().method_23000(), 0xF000F0);
    }

    public static void finishProjectedText() {
        class_310.method_1551().method_22940().method_23000().method_22993();
        RenderSystem.setShaderFogStart((float)lastFog);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
    }
}

